
import getopt
import sys

trainingData = [
        ('genomes/genome1.fa', 'annotations/annotation1.fa'),
        ('genomes/genome2.fa', 'annotations/annotation2.fa'),
        ('genomes/genome3.fa', 'annotations/annotation3.fa'),
        ('genomes/genome4.fa', 'annotations/annotation4.fa'),
        ('genomes/genome5.fa', 'annotations/annotation5.fa'),
        ]

def parseOpts(argv):
    inputfile = ''
    outputfile = ''
    model = ''
    dot = False
    cross = False

    try:
        opts, args = getopt.getopt(argv,"hi:o:m:cd",
                ["input", "output=","model=", "cross="])
    except getopt.GetoptError:
        print('main.py -m <model> -i <inputfile> -o <outputfile> -c <crossvalidation> -d')
        sys.exit(2)
    except Exception as e:
        print("Unknown exceptions occurred: " + e)
        sys.exit(2)

    for opt, arg in opts:
        if opt == '-h':
            print('main.py -m <model> -i <inputfile> -o <outputfile> -c <crossvalidation>')
            sys.exit()
        elif opt in ("-m", "--model"):
            model = arg
        elif opt in ("-c", "--cross"):
            cross = True
        elif opt in ("-i", "--input"):
            inputfile = arg
        elif opt in ("-d"):
            dot = True
        elif opt in ("-o", "--output"):
            outputfile = arg

    if model == "" and not cross:
        print("Error: No model given")
        print('main.py -m <model> -o <outputfile> -c <crossvalidation>')
        sys.exit(1)

    if inputfile == "" and not cross:
        print("Error: No input file given")
        print('main.py -m <model> -o <outputfile> -c <crossvalidation>')
        sys.exit(1)

    if outputfile == "" and not cross:
        print("Error: No output file given")
        print('main.py -m <model> -i <inputfile> -o <outputfile> -c <crossvalidation>')
        sys.exit(1)

    return (inputfile, outputfile, model, cross, dot)

