module PyInterface

export parseModel, createHMM, trainByCounting, normalize, readFasta

using PyCall

unshift!(PyVector(pyimport("sys")["path"]), "")
@pyimport HMM
@pyimport train
@pyimport fasta


function parseModel(file)
	return HMM.readJsonFile(file)
end

function createHMM(model)
	return HMM.createHMM(model)	
end

function trainByCounting(hmm, pair)
	train.trainByCounting(hmm, pair)
end

function normalize(hmm)
	train.normalize(hmm)
end

function readFasta(file)
	return fasta.read(file)
end

end
