#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <unistd.h>

// For stat()
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include <streams.h>

uint64_t filesize(char *file) {
	struct stat buf;
	int r = stat(file, &buf);
	if (r == -1) {
		fprintf(stderr, "Cannot stat '%s': '%s'\n", file, strerror(errno));
		exit(EXIT_FAILURE);
	}

	return buf.st_size;
}

void *xcalloc(size_t nmemb, size_t size) {
	void *p = calloc(nmemb, size);

	if (p == NULL) {
		fprintf(stderr, "Unable to c-allocate memory.");
		exit(EXIT_FAILURE);
	}

	return p;
}

void *xmalloc(size_t size) {
	void *p = malloc(size);

	if (p == NULL) {
		fprintf(stderr, "Unable to m-allocate memory.");
		exit(EXIT_FAILURE);
	}

	return p;
}

void *xrealloc(void *ptr, size_t size) {
	void *p = realloc(ptr, size);

	if (p == NULL) {
		fprintf(stderr, "Unable to re-allocate memory.");
		exit(EXIT_FAILURE);
	}

	return p;
}

void removefile(char *f) {
	struct stat buf;
	int r = stat(f, &buf);
	if (r == -1) {
		return;
	}

	unlink(f);
}

int intcmp(const void *a, const void *b) {
	return *(uint32_t*)a > *(uint32_t*)b;
}

int open_input_stream(char *f, uint64_t start, uint64_t length) {
	extern int STREAM_TYPE;
	extern int BUFFER;
	int fd;

	switch(STREAM_TYPE) {
	case 1:
		fd = i_open(f, start, length);
		break;

	case 2:
		fd = fi_open(f, start, length);
		break;

	case 3:
		fd = bi_open(f, start, length, BUFFER);
		break;

	case 4:
		fd = mi_open(f, start, length, BUFFER);
		break;

	default:
		fprintf(stderr, "Invalid stream type\n");
		exit(EXIT_FAILURE);
		break;
	}

	return fd;
}

int open_output_stream(char *f, uint64_t start, uint64_t length) {
	extern int STREAM_TYPE;
	extern int BUFFER;
	int fd;

	switch(STREAM_TYPE) {
	case 1:
		fd = o_create(f, start);
		break;

	case 2:
		fd = fo_create(f, start);
		break;

	case 3:
		fd = bo_create(f, start, BUFFER);
		break;

	case 4:
		fd = mo_create(f, start, length, BUFFER);
		break;

	default:
		fprintf(stderr, "Invalid stream type\n");
		exit(EXIT_FAILURE);
		break;
	}

	return fd;
}
