#define _DEFAULT_SOURCE
#include <stdlib.h>
#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <getopt.h>
#include <sys/mman.h>
#include <sys/sysinfo.h>	
#include <sys/types.h>
#include <sys/wait.h>

void *xmalloc(size_t size) {
	void *p = malloc(size);

	if (p == NULL) {
		fprintf(stderr, "Unable to m-allocate memory.");
		exit(EXIT_FAILURE);
	}

	return p;
}

int main(int argc, char* argv[]) {
	int pid, r, j;
	struct sysinfo si;
	uint64_t size, i;
	uint64_t M = 230686720; 
	int64_t pagesize;
	char *ptr;
	char **new_argv = xmalloc(sizeof(char *)*(argc));

	if (argc < 2) {
		fprintf(stderr, "memlock should receive at least one argument.\n");
		exit(EXIT_FAILURE);
	}

	r = system("echo 3 > /proc/sys/vm/drop_caches");
	if (r < 0) {
		fprintf(stderr, "Error dropping caches");
		exit(EXIT_FAILURE);
	}
	r = system("blockdev --flushbufs /dev/sda");
	if (r < 0) {
		fprintf(stderr, "Error flushing buffers");
		exit(EXIT_FAILURE);
	}
	r = system("sync");                                                         
	if (r < 0) {
		fprintf(stderr, "Error syncing");
		exit(EXIT_FAILURE);
	}

	r = sysinfo(&si);

	if (r < 0) {	
		fprintf(stderr, "Error when requesting sysinfo: %s\n", strerror(r));
		exit(EXIT_FAILURE);
	}

	pagesize = sysconf(_SC_PAGESIZE);

	if (pagesize < 0) {	
		fprintf(stderr, "Error when requesting pagesize: %s\n", strerror(r));
		exit(EXIT_FAILURE);
	}

	size = (si.freeram+si.bufferram+si.sharedram) - M;

	ptr = xmalloc(size);

	r = mlock(ptr, size);

	if (r < 0) {	
		free(ptr);
		fprintf(stderr, "Error when using mlock: %s\n", strerror(r));
		exit(EXIT_FAILURE);
	}

	for (i = 0; i < size; i += pagesize) {
		ptr[i] = 0;
	}

	for (j = 1; j < argc; j++) {
		new_argv[j-1] = argv[j];
	}
	new_argv[argc-1] = NULL;


	pid = fork();
	if (pid == 0) {
		r = execve(new_argv[0], new_argv, NULL);
		if (r < 0) {
			fprintf(stderr, "Error when using execve: %s\n", strerror(r));
			exit(EXIT_FAILURE);
		}
		return EXIT_SUCCESS;
	} else {
		wait(NULL);
	}
	// Run program

	r = munlock(ptr, size);	

	free(new_argv);
	free(ptr);
	
	if (r < 0) {	
		fprintf(stderr, "Error when using mlock: %s\n", strerror(r));
		exit(EXIT_FAILURE);
	}

	return EXIT_SUCCESS;
}
