#define _DEFAULT_SOURCE
#include <streams.h>
#include <stdlib.h>
#include <stdint.h>
#include <stdio.h>

#include "mergesort.h"
#include "dmerge.h"
#include "qsort.h"

TAILQ_HEAD(tailqhead, entry);

void mergesort(char *input, char *output, in_stream *in, out_stream *out, uint64_t N, unsigned int M, unsigned int d) {
	struct tailqhead *head = sortfile(input, output, in, out, N, M);

	if(N > (unsigned int)M) {
		// Merge d streams at a time, until only one is left.
		char *sorted = merge_streams(in, out, d, head);
		rename(sorted, output);
		free(sorted);
	}

	free(head);

	/*
	int fd = in->open(output, 0, N/sizeof(uint32_t));
	int k = 0;
	uint32_t prev = 0;
	while (!in->eos(fd)) {
		uint32_t now = in->next(fd);
		k++;

		if (prev > now) {
			fprintf(stderr, "HUGE ERROR %u > %u at %d\n", prev, now, k);
			exit(EXIT_FAILURE);
		}

		prev = now;
	}

	in->close(fd);
	// */
}

// We define N and M in bytes.
struct tailqhead *sortfile(char *input, char *output, in_stream *in, out_stream *out, uint64_t N, unsigned int M) {
	unsigned int i;
	uint64_t file_index = 0,
		elements = N/sizeof(uint32_t);

	struct tailqhead *head = xmalloc(sizeof(struct tailqhead));
	TAILQ_INIT(head);

	entry_t *e;

	int infd = in->open(input, 0, elements);
	int outfd = out->create(output, 0, elements);

	uint32_t *buf = xmalloc(M);

	do {
		uint64_t bptr = 0;
		while(!in->eos(infd) && bptr * sizeof(uint32_t) + sizeof(uint32_t) <= M) {
			buf[bptr] = in->next(infd);
			bptr++;
		}

		quicksort(buf, 0, bptr-1);

		int fd = in->open(output, file_index, bptr);
		e = xmalloc(sizeof(entry_t));
		e->fd = fd;
		e->filename = NULL;
		e->size = bptr;
		TAILQ_INSERT_TAIL(head, e, entries);

		for (i = 0; i < bptr; i++) {
			out->write(outfd, buf[i]);
			file_index += 1;
		}

	} while(!in->eos(infd));

	in->close(infd);
	out->close(outfd);

	free(buf);

	return head;
}

char *merge_streams(in_stream *in, out_stream *out, unsigned int d, struct tailqhead *head) {
	unsigned int i, j;
	int outfd;
	entry_t *e;
	int *ifds = xmalloc(sizeof(int) * d);
	char *res = NULL;

	while (1) {
		uint64_t size = 0;
		for (i = 0, e = head->tqh_first; i < d && e != NULL; i++, e = e->entries.tqe_next) {
			ifds[i] = e->fd;
			size += e->size;
		}

		if (i == 1) {
			e = head->tqh_first;
			res = e->filename;
			int fd = e->fd;

			in->close(fd);

			TAILQ_REMOVE(head, head->tqh_first, entries);

			free(e);
			break;
		}

		char *newfile = tempnam(".", NULL);
		outfd = out->create(newfile, 0, size);

		uint64_t written = dmerge(i, in, ifds, out, outfd);

		out->close(outfd);

		for (j = 0; j < i; j++) {
			in->close(ifds[j]);

			e = head->tqh_first;
			TAILQ_REMOVE(head, head->tqh_first, entries);

			if (e->filename != NULL) {
				removefile(e->filename);
				free(e->filename);
			}

			free(e);
		}

		// Create inputstream for the newly created file.
		int fd = in->open(newfile, 0, written);
		e = xmalloc(sizeof(entry_t));
		e->fd = fd;
		e->filename = newfile;
		e->size = written;
		TAILQ_INSERT_TAIL(head, e, entries);
	}

	free(ifds);

	return res;
}
