#!/usr/bin/env bash

DIR=$1

if [[ ${DIR} == "-h" || ${DIR} == "--help" ]]; then
	echo "Change name of all 'changefile*' files in directory"
	exit
fi

if [[ -z ${DIR} ]]; then
	echo "Please specify a directory"
	exit
fi

if [[ ! -d ${DIR} ]]; then
	echo "Please specify an existing directory"
	exit
fi

cd ${DIR}

for i in changefile*; do
    D=$( echo ${i} | sed 's/changefile//' )

    N=$( printf "%d" ${D} )
    N=$( printf "%04d" ${N} )

	if [[ ${i} != "changefile${N}" ]]; then
		mv ${i} "changefile${N}"
	fi
done
