#ifndef H_naive
#define H_naive

#include <inttypes.h>

#include "matrix.h"
#include "bitmatrix.h"

typedef struct {
	uint32_t n;
	uint32_t tc;
	matrix_t *restrict T0;
	matrix_t *restrict Tn;
	matrix_t *restrict temp;
} naive_t;

typedef struct {
	uint32_t n;
	uint32_t tc;
	bitmatrix_t *restrict T0;
	bitmatrix_t *restrict Tn;
	bitmatrix_t *restrict temp;
} bitnaive_t;

naive_t *naive_init(uint32_t n); 
bitnaive_t *bitnaive_init(uint32_t n); 

void naive_destroy(naive_t *naive);
void naive_delete(naive_t *naive, uint32_t i, uint32_t j);
void naive_insert(naive_t *naive, uint32_t i, uint32_t j);
uint32_t naive_query(naive_t *naive);

void bitnaive_destroy(bitnaive_t *naive);
void bitnaive_delete(bitnaive_t *naive, uint32_t i, uint32_t j);
void bitnaive_insert(bitnaive_t *naive, uint32_t i, uint32_t j);
uint32_t bitnaive_query(bitnaive_t *naive);

void naive_expand(naive_t *naive);
void naive_remove(naive_t *naive, uint32_t i);

#endif
