#ifndef H_bitvector_popcount
#define H_bitvector_popcount

#include <stdint.h>

#include "bitvector.h"

typedef struct {
	uint64_t s;
	uint64_t b;
	uint64_t bits;
	double logS;
	bitvector *restrict Rs;
	bitvector *restrict Rb;
} popcount_t;

void succinct_popcount_preprocess(bitvector_t *restrict B); 

void succinct_popcount_postprocess(bitvector_t *restrict B);

uint64_t succinct_popcount_rank(struct succinct_t *restrict succ);

uint64_t succinct_popcount_select(struct succinct_t *restrict succ); 

#endif
