#ifndef H_popcount
#define H_popcount

typedef unsigned long long u64;
typedef unsigned int       u32;

// Taken from https://gcc.gnu.org/bugzilla/attachment.cgi?id=15529 
inline u32 popcount(u64 x) {
    x = (x & 0x5555555555555555ULL) + ((x >>  1) & 0x5555555555555555ULL);
    x = (x & 0x3333333333333333ULL) + ((x >>  2) & 0x3333333333333333ULL);
    x = (x & 0x0F0F0F0F0F0F0F0FULL) + ((x >>  4) & 0x0F0F0F0F0F0F0F0FULL);
    return (((u32)(x >> 32)) * 0x01010101 >> 24) + 
           (((u32)(x      )) * 0x01010101 >> 24);
}

#endif
