#include <stdio.h>
#include <inttypes.h>

#include "naive_popcount.h"
#include "bitvector.h"

/**
 * Returns amount of the 1's up until the i'th offset in the bitvector B
 */
uint64_t succinct_naive_popcount_rank(struct succinct_t *restrict succ) {
	bitvector_t *restrict B = succ->B;
	uint64_t i = succ->i;
	uint64_t imodw = i % WORD;
	uint64_t c = 0;
	uint64_t k;

	if (i != 0) {
		for (k = 0; k < i/WORD; k++) {
			c += __builtin_popcountll(B->B[k]);
		}
		
		if (imodw) {
			c += __builtin_popcountll( (B->B[k] >> (WORD-imodw)) );
		}
	}

	return c;
}

/**
 * Returns offset of the j'th accurance of 1 in the bitvector B
 */
uint64_t succinct_naive_popcount_select(struct succinct_t *restrict succ) {
	bitvector_t *restrict B = succ->B;
	uint64_t j = succ->i;
	uint64_t bits = B->bits;
	uint64_t c = 0;
	uint64_t l = 0;
	uint64_t k = 0;
	uint64_t i;

	if (j >= bits) {
		return bits;
	}

	if (j != 0) {
		for (i = 0; i < bits/WORD; i++) {
			l = __builtin_popcountll(B->B[i]);
			if (c+l >= j) {
				break;
			}
			c += l;
			l = 0;
		}
		
		if (i > 0 && c >= j) {
			k = (i-1)*WORD;
		} else if ( i == 0 ) {
			k = 0;
		} else {
			k = i*WORD;
		}
		
		while (c < j && k+1 <= bits) {
			if ( BIT(B, k+1) ) {
				c++;
			}
			k++;
		}
	}

	return k;
}
