#include <stdio.h>
#include <inttypes.h>

#include "naive.h"
#include "bitvector.h"

/**
 * Returns amount of the 1's up until the i'th offset in the bitvector B
 */
uint64_t succinct_naive_rank(struct succinct_t *restrict succ) {
	bitvector_t *restrict B = succ->B;
	uint64_t i = succ->i;
	uint64_t k = 1;
	uint64_t c = 0;
	uint64_t bits = B->bits;

	if (i != 0) {
		while (k <= i && k <= bits) {
			if ( BIT(B, k) ) {
				c++;
			}
			k++;
		}
	}

	return c;
}

/**
 * Returns offset of the j'th accurance of 1 in the bitvector B
 */
uint64_t succinct_naive_select(struct succinct_t *restrict succ) {
	bitvector_t *restrict B = succ->B;
	uint64_t j = succ->i;
	uint64_t k = 0;
	uint64_t c = 0;
	uint64_t bits = B->bits;

	if (j != 0) {
		while (c < j && k+1 <= bits) {
			if ( BIT(B, k+1) ) {
				c++;
			}
			k++;
		}
	}

	return k;
}
