#ifndef H_bitvector_classic
#define H_bitvector_classic

#include <stdint.h>

#include "bitvector.h"

typedef struct {
	uint64_t s;
	uint64_t b;
	uint64_t bits;
	double logS;
	bitvector *restrict Rs;
	bitvector *restrict Rb;
	bitvector *restrict Rp;
} classic_t;


void succinct_classic_preprocess(bitvector_t *restrict B); 

void succinct_classic_postprocess(bitvector_t *restrict B);

uint64_t succinct_classic_rank(struct succinct_t *restrict succ);

uint64_t succinct_classic_select(struct succinct_t *restrict succ);

#endif
