#ifndef H_bitvector_clark
#define H_bitvector_clark

#include <stdint.h>

#include "bitvector.h"

typedef struct {
	uint64_t logSize;
	uint64_t spc1;
	uint64_t bits1;
	bitvector *restrict D1;
	bitvector *restrict D2;
	bitvector *restrict D3;
	bitvector *restrict L1;
	bitvector *restrict L2;
} clark_t;

void succinct_clark_preprocess(bitvector_t *restrict B); 

void succinct_clark_postprocess(bitvector_t *restrict B);

uint64_t succinct_clark_select(struct succinct_t *restrict succ);

#endif
