#include <inttypes.h>
#include <assert.h>

#include "naive_idx.h"
#include "matrix.h"

// C = AB
// A \in m \times n
// B \in n \times p
// C \in m \times p
//

void mm_naive_mult_idx(matrix_t *A, matrix_t *B, matrix_t *C, uint32_t m, 
		uint32_t n, uint32_t p) {
	uint32_t i, j, k;
	uint32_t na = 0;
	uint32_t nb = 0;
	uint32_t nc = 0;
	int32_t sum;

	int32_t *restrict a = A->data;
	int32_t *restrict b = B->data;
	int32_t *restrict c = C->data;

	for (i = 0; i < m ; i++) {
		for (j = 0; j < p ; j++) {
			nb = 0;
			sum = 0;

			for (k = 0; k < n ; k++) {
				sum += a[na + k] * b[nb + j];
				nb += p;
			}

			c[nc + j] = sum;
		}
		na += n;
		nc += p;
	}
}

void naive_idx(struct matrix_mult *str){
	matrix_t * A = str->A;
	matrix_t * B = str->B;
	matrix_t * C = str->C;

	assert(A->n == B->m);

	mm_naive_mult_idx(A, B, C, A->m, A->n, B->n);
}
