#ifndef H_matrix
#define H_matrix

#define MAT(matrix,i,j) matrix->data[j + (matrix->n*i)]

#define MAT_IDX(matrix,i) matrix->data[i]

#include <inttypes.h>

typedef struct {
	int32_t *restrict data;
	uint32_t m;
	uint32_t n;
} matrix_t;

struct matrix_mult {
	matrix_t *restrict A;
	matrix_t *restrict B;
	matrix_t *restrict C;
};

struct strassen_mult {
	matrix_t *restrict A;
	matrix_t *restrict B;
	matrix_t *restrict C;
	uint32_t th;
};

matrix_t *matrix_create(uint32_t m, uint32_t n); 

void matrix_destroy(matrix_t *matrix);

void matrix_randomize(matrix_t *A, unsigned int seed);

void matrix_zero(matrix_t *matrix);

#endif
