#include <stdint.h>
#include <stdio.h>
#include <string.h>
#include <inttypes.h>

#include "inorder.h"
#include "qsort.h"
#include "xutil.h"

inorder_t *inorder_create(uint32_t *array, uint32_t N, double skew) {
	uint32_t size = N*sizeof(uint32_t);
	inorder_t *inorder = xmalloc(sizeof(inorder_t));

	inorder->storage = xmalloc(size);
	inorder->nodes = N;
	inorder->skew = skew;

	memset(inorder->storage, '\0', size);
	memcpy(inorder->storage, array, size);

	quicksort(inorder->storage, 0, N-1);

	return inorder;
}

uint32_t inorder_pred(struct inorder_search *restrict str) {
	uint32_t x = str->x;
	inorder_t *restrict inorder = str->inorder;
	int32_t l = 0;
	int32_t r = inorder->nodes;
	int32_t mid;

	while (r-l > 1) {
		mid = l + ((r-l) >> 1);

		// cmpl    %edi, (%rsi,%rcx,4) # Compare to memory location
		// cmovbe  %eax, %edx       # l = mid (below equal)
		// cmova   %eax, %r8d       # r = mid (above)

		if (inorder->storage[mid] > x) {
			r = mid;
		} else {
			l = mid;
		}
	}

	return inorder->storage[l];
}

uint32_t inorder_skew_pred(uint32_t x, inorder_t *restrict inorder) {
	int32_t l = 0;
	int32_t r = inorder->nodes;
	int32_t mid;
	double skew = inorder->skew;

	while (r-l > 1) {
		//mid = l + ((r-l) >> 1);
		mid = l + (r-l)/(1/skew);

		if (inorder->storage[mid] <= x) {
			l = mid;
		} else {
			r = mid;
		}
	}

	return inorder->storage[l];
}

/*
With variable used for storage.
	.cfi_startproc
	movl	8(%rsi), %r8d
	movsd	16(%rsi), %xmm4
	xorl	%edx, %edx
	movq	(%rsi), %rsi
	movsd	.LC2(%rip), %xmm3
	jmp	.L11
	.p2align 4,,10
	.p2align 3
.L12:
	movapd	%xmm3, %xmm2
	pxor	%xmm0, %xmm0
	divsd	%xmm4, %xmm2
	cvtsi2sd	%eax, %xmm0
	pxor	%xmm1, %xmm1
	divsd	%xmm2, %xmm0
	cvtsi2sd	%edx, %xmm1
	addsd	%xmm1, %xmm0
	cvttsd2si	%xmm0, %eax
	movslq	%eax, %rcx
	cmpl	%edi, (%rsi,%rcx,4)
	cmova	%eax, %r8d
	cmovbe	%eax, %edx




With no variable used for storage.
    .cfi_startproc
    movl    8(%rsi), %r9d
    movq    (%rsi), %r8
    xorl    %edx, %edx
    movsd   .LC2(%rip), %xmm3
    jmp .L11
    .p2align 4,,10
    .p2align 3
.L12:
    movapd  %xmm3, %xmm2
    pxor    %xmm0, %xmm0
    divsd   16(%rsi), %xmm2
    cvtsi2sd    %eax, %xmm0
    pxor    %xmm1, %xmm1
    cvtsi2sd    %edx, %xmm1
    divsd   %xmm2, %xmm0
    addsd   %xmm1, %xmm0
    cvttsd2si   %xmm0, %eax
    movslq  %eax, %rcx
    cmpl    %edi, (%r8,%rcx,4)
    cmova   %eax, %r9d
    cmovbe  %eax, %edx

*/
