#ifndef H_matrix
#define H_matrix

#define MAT(matrix, i, j) matrix->data[j + (matrix->n*i)]

#define MAT_IDX(matrix,i) matrix->data[i]

#include <inttypes.h>

typedef struct {
	int64_t *restrict data;
	uint32_t m;
	uint32_t n;
} matrix_t;

matrix_t *matrix_create(uint32_t m, uint32_t n); 

void matrix_destroy(matrix_t *matrix);
void matrix_print(matrix_t *matrix);

#endif
