#include <stdlib.h>
#include <stdio.h>

#include "xutil.h"
#include "matrix.h"

matrix_t *matrix_create(uint32_t m, uint32_t n) {
	int64_t size = m*n*sizeof(int64_t);
	matrix_t *matrix = xmalloc(sizeof(matrix_t));

	matrix->data = xmalloc(size);
	matrix->m = m;
	matrix->n = n;

	xmemset(matrix->data, size);

	return matrix;
}

void matrix_destroy (matrix_t *matrix) {
	if (matrix != NULL) {
		if (matrix->data != NULL) {
			free(matrix->data);
		}
		free(matrix);
	}
}

void matrix_print(matrix_t *matrix) {
	uint32_t i, j;
	uint32_t n = matrix->n;
	
	for (i = 0; i < n; i++) {
		for (j = 0; j < n; j++) {
			printf("% 12"PRId64, MAT(matrix, i, j));
		}

		printf("\n");
	}
}
