#ifndef HEAPH
#define HEAPH
#include <inttypes.h>

#include "node.h"

typedef void *(*Create)(void);
typedef void(*Free)(void *);
typedef Node_t *(*Insert)(void *, int64_t);
typedef Node_t *(*DeleteMin)(void *);
typedef void(*Delete)(void *, Node_t *);
typedef Node_t *(*FindMin)(void *);
typedef void(*DecreaseKey)(void *, uint64_t, Node_t *);
typedef void(*DecreaseKeyTo)(void *, int64_t, Node_t *);
typedef bool(*IsEmpty)(void *);

typedef struct {
	void         *heap;
	IsEmpty       empty;
	Create        create;
	Free          free;
    Insert        insert;
    DeleteMin     deletemin;
    Delete        delete;
    FindMin       findmin;
    DecreaseKey   decreasekey;
    DecreaseKeyTo decreasekeyto;
} heap_t;

#endif
