#ifndef H_FIBONACCI_HEAP
#define H_FIBONACCI_HEAP

#include <stdint.h>
#include <stdbool.h>

#include "node.h"

#ifdef COUNT_COMPARISONS
extern uint64_t fib_comps;
extern uint64_t fib_insert_comps;
extern uint64_t fib_deletemin_comps;
extern uint64_t fib_decreasekey_comps;
#endif

typedef struct {
	Node_t *min;
	uint64_t n;
} FibonacciHeap_t;

FibonacciHeap_t *MakeFibonacciHeap();
void             FreeFibonacciHeap(FibonacciHeap_t *h);
void             DrawFibonacciHeap(FibonacciHeap_t *h, const char *name); 

bool             FibonacciHeapIsEmpty(FibonacciHeap_t *h);
Node_t          *FibonacciHeapFindMin(FibonacciHeap_t *h);
Node_t          *FibonacciHeapInsert(FibonacciHeap_t *h, int64_t i);
Node_t          *FibonacciHeapDeleteMin(FibonacciHeap_t *h);
void             FibonacciHeapDecreaseKeyTo(FibonacciHeap_t *h, int64_t val, Node_t *x);
void             FibonacciHeapDecreaseKey(FibonacciHeap_t *h, uint64_t val, Node_t *x);
void             FibonacciHeapDelete(FibonacciHeap_t *h, Node_t *x);

#endif
