#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <inttypes.h>

#include "draw_fibonacci.h"
#include "xutil.h"
#include "node.h"

void
recursivelyDrawLevel(FILE *fp, Node_t *n) {
	Node_t *start, *next;

	if ( NULL == n ) {
		return;
	}

	start = n;

	if ( n->marked ) {
		fprintf(fp, "\t%"PRIu64" [label=\"%"PRId64"\", style=\"filled\", fillcolor=\"red\"];\n", (uint64_t)n, n->key);
	} else {
		fprintf(fp, "\t%"PRIu64" [label=\"%"PRId64"\"];\n", (uint64_t)n, n->key);
	}

	/* Draw arrow to parent or make minimum element */
	if ( NULL != n->parent ) {
		fprintf(fp, "\t%"PRIu64" -> %"PRIu64";\n", (uint64_t)n, (uint64_t)n->parent);
	} else {
		fprintf(fp, "\t%"PRIu64" [shape=box];\n", (uint64_t)n);
	}

	/* Draw arrow to child */
	if ( NULL != n->child ) {
		fprintf(fp, "\t%"PRIu64" -> %"PRIu64";\n", (uint64_t)n, (uint64_t)n->child);
	}

	/* Draw arrow to siblings */
	if ( n->prevSibling != n->nextSibling || n != n->nextSibling ) {
		fprintf(fp, "\t%"PRIu64" -> %"PRIu64" [ label=\"prev\" ];\n", (uint64_t)n, (uint64_t)n->prevSibling);
		fprintf(fp, "\t%"PRIu64" -> %"PRIu64" [ label=\"next\" ];\n", (uint64_t)n, (uint64_t)n->nextSibling);
	}
	
	next = start->nextSibling;
	while (next != start) {
		if ( next->marked ) {
			fprintf(fp, "\t%"PRIu64" [label=\"%"PRId64"\", style=\"filled\", fillcolor=\"red\"];\n", (uint64_t)next, next->key);
		} else {
			fprintf(fp, "\t%"PRIu64" [label=\"%"PRId64"\", fillcolor=\"red\"];\n", (uint64_t)next, next->key);
		}

		/* Draw arrow to parent or make minimum element */
		if ( NULL != next->parent ) {
			fprintf(fp, "\t%"PRIu64" -> %"PRIu64";\n", (uint64_t)next, (uint64_t)next->parent);
		}

		/* Draw arrow to child */
		if ( NULL != next->child ) {
			fprintf(fp, "\t%"PRIu64" -> %"PRIu64";\n", (uint64_t)next, (uint64_t)next->child);
		}

		/* Draw arrow to siblings */
		if (next->prevSibling != next->nextSibling || next != next->nextSibling) {
			fprintf(fp, "\t%"PRIu64" -> %"PRIu64" [ label=\"prev\" ];\n", (uint64_t)next, (uint64_t)next->prevSibling);
			fprintf(fp, "\t%"PRIu64" -> %"PRIu64" [ label=\"next\" ];\n", (uint64_t)next, (uint64_t)next->nextSibling);
		}

		next = next->nextSibling;
	};

	fprintf(fp, "\t{ rank = same;");
	do {
		fprintf(fp, " %"PRIu64";", (uint64_t)next);
		next = next->nextSibling;
	} while (next != start);
	fprintf(fp, " };\n");
			
	do {
		recursivelyDrawLevel(fp, next->child);
		next = next->nextSibling;
	} while (next != start);
}

void
DrawFibonacciHeap(FibonacciHeap_t *h, const char *name) { 
	FILE *fp;
	char buf[256];
	int res;

	if ( NULL == h->min ) {
		return;
	}

	snprintf(buf, 244, "images/%s.dot", name);

	fp = fopen(buf, "w+");

	if (NULL == fp) {
		xerror(strerror(errno), __LINE__, __FILE__);
	}

	fprintf(fp, "digraph {\n");
	fprintf(fp, "\tgraph [pad=\".75\", ranksep=\".75\", nodesep=\".75\"];\n");
	recursivelyDrawLevel(fp, h->min);
	fprintf(fp, "}");

	if (fclose(fp) != 0) {
		xerror(strerror(errno), __LINE__, __FILE__);
	}

	snprintf(buf, 220, "dot -Tpng images/%s.dot > images/%s.png", name, name);

	res = system(buf);
	(void)res;
}
