#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <inttypes.h>

#include "draw_binary.h"
#include "binaryheap.h"
#include "xutil.h"
#include "node.h"

void recursivelyDrawTree(FILE* fp, BinaryHeap_t *h, uint64_t idx) {
	Node_t **A = h->A;
	Node_t *node;
	uint64_t n = h->n,
	         left = 2*idx,
	         right = 2*idx+1;

	idx--;

	node = A[idx];

	if ( idx >= n || NULL == node ) {
		return;
	}

	if ( unlikely(idx == 0) ) {
		fprintf(fp, "\t%"PRIu64" [shape=\"box\", label=\"%"PRId64"\"];\n", (uint64_t)node, node->key);
	} else {
		fprintf(fp, "\t%"PRIu64" [label=\"%"PRId64"\"];\n", (uint64_t)node, node->key);
	}

	if ( left <= n && NULL != A[left-1] ) {
		fprintf(fp, "\t%"PRIu64" -> %"PRIu64";\n", (uint64_t)node, (uint64_t)A[left-1]);
		recursivelyDrawTree(fp, h, left);
	}

	if ( right <= n && NULL != A[right-1] ) {
		fprintf(fp, "\t%"PRIu64" -> %"PRIu64";\n", (uint64_t)node, (uint64_t)A[right-1]);
		recursivelyDrawTree(fp, h, right);
	}

	if ( right <= n && NULL != A[right-1] && left <= n && NULL != A[left-1] ) {
		fprintf(fp, "\t{ rank = same; %"PRIu64"; %"PRIu64"; };\n", (uint64_t)A[left-1], (uint64_t)A[right-1]);
	}
}

void
DrawBinaryHeap(BinaryHeap_t *h, const char *name) {
	FILE *fp;
	char buf[256];
	int res;

	if (h->n == 0) {
		return;
	}

	snprintf(buf, 244, "images/%s.dot", name);

	fp = fopen(buf, "w+");

	if ( NULL == fp ) {
		xerror(strerror(errno), __LINE__, __FILE__);
	}

	fprintf(fp, "digraph {\n");
	fprintf(fp, "\tgraph [pad=\".75\", ranksep=\".75\", nodesep=\".75\"];\n");
	recursivelyDrawTree(fp, h, 1);
	fprintf(fp, "}");

	if ( fclose(fp) != 0 ) {
		xerror(strerror(errno), __LINE__, __FILE__);
	}

	snprintf(buf, 220, "dot -Tpng images/%s.dot > images/%s.png", name, name);

	res = system(buf);
	(void)res;
}
