#ifndef DIJKSTRAH
#define DIJKSTRAH

#include "matrix.h"
#include "fibonacciheap.h"
#include "binaryheap.h"
#include "node.h"
#include "heap.h"

struct dijk_measure {
	matrix_t *matrix;
	heap_t   *heap;
	uint64_t  source;
	bool      result;
	Node_t  **nodes;
};

matrix_t *read_graph_matrix(char *filename);

Node_t **Dijkstra(struct dijk_measure* d);
Node_t **Dijkstra2(struct dijk_measure* d);

#endif
