#ifndef H_BINARY_HEAP
#define H_BINARY_HEAP

#include <stdint.h>
#include <stdbool.h>

#include "node.h"
#include "xutil.h"

#ifdef COUNT_COMPARISONS
extern uint64_t bin_comps;
extern uint64_t bin_insert_comps;
extern uint64_t bin_deletemin_comps;
extern uint64_t bin_decreasekey_comps;
#endif

typedef struct {
	Node_t **A;
	uint64_t n;
	uint64_t size;
} BinaryHeap_t;

BinaryHeap_t *MakeBinaryHeap();
void FreeBinaryHeap(BinaryHeap_t *h);

bool    BinaryHeapIsEmpty(BinaryHeap_t *h);
Node_t *BinaryHeapFindMin(BinaryHeap_t *h);
Node_t *BinaryHeapInsert(BinaryHeap_t *h, int64_t in);
Node_t *BinaryHeapDeleteMin(BinaryHeap_t *h);
void    BinaryHeapDecreaseKeyTo(BinaryHeap_t *h, int64_t val, Node_t *x);
void    BinaryHeapDecreaseKey(BinaryHeap_t *h, uint64_t val, Node_t *x);
void    BinaryHeapDelete(BinaryHeap_t *h, Node_t *x);

#endif
