#!/bin/bash

set -e

if [[ -z "$1" || "$1" == "heap" ]]; then
	export LC_NUMERIC=en_US.UTF-8
	Ns=$(seq 100 100 1000)
	Es=$(seq 0.1 0.1 1)

	mkdir -p ../generated

	for n in ${Ns}; do
		for e in ${Es}; do
			./generate_workload.py -n ${n} -e ${e} > ../generated/${n}-${e}.heap
		done
	done
elif [[ "$1" == "rand" ]]; then
	Reps=$(seq 2)
	Ns=$(seq 1000 1000 30000)

	mkdir -p ../rand_graphs

	for n in ${Ns}; do
		for r in ${Reps}; do
			./graph_generator.py -n ${n} > ../rand_graphs/${n}-${r}.graph -t rand
		done
	done
elif [[ "$1" == "chain" ]]; then
	Reps=$(seq 2)
	Ns=$(seq 1000 1000 30000)

	mkdir -p ../chain_graphs

	for n in ${Ns}; do
		for r in ${Reps}; do
			./graph_generator.py -n ${n} > ../chain_graphs/${n}-${r}.graph -t chain
		done
	done
elif [[ "$1" == "best" ]]; then
	Reps=$(seq 2)
	Ns=$(seq 1000 1000 10000)

	mkdir -p ../best_graphs

	for n in ${Ns}; do
		for r in ${Reps}; do
			./graph_generator.py -n ${n} > ../best_graphs/${n}-${r}.graph -t best
		done
	done
fi
