#include "streams.h"
#include "stream_common.h"
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <stdint.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

typedef struct input {
	int fd;
	uint64_t end;
	uint64_t cur;
} input_stream;

typedef struct output {
	int fd;
} output_stream;

static input_stream **in_list;
static int in_len;

static output_stream **out_list;
static int out_len;

__attribute__ ((visibility("default")))
int i_open(const char *f, uint64_t start, uint64_t length) {
	int id = 0;

	id = stream_find_struct_storage((uintptr_t **)&in_list, &in_len);

	input_stream *s =  xmalloc(sizeof(input_stream));
	in_list[id] = s;

	s->fd = open(f, O_RDONLY | O_CREAT, S_IRUSR | S_IWUSR);

	if(s->fd < 0) {
		printf("Error in i_open: '%s'\n", strerror(errno));
		exit(1);
	}

	s->cur = sizeof(uint32_t) * start;
	s->end = sizeof(uint32_t) * (start + length);

	lseek(s->fd, s->cur, SEEK_SET);

	return id;
}

__attribute__ ((visibility("default")))
uint32_t i_next(int id) {
	int32_t res;
	int er = 0;
	input_stream *i = in_list[id];
	er = read(i->fd, &res, sizeof(uint32_t));

	if (er == -1) {
		errorAndDie(1);
	}

	i->cur += sizeof(uint32_t);

	return res;
}

__attribute__ ((visibility("default")))
int i_eos(int id) {
	input_stream *i = in_list[id];
	if(i->cur >= i->end) {
		return 1;
	}

	return 0;
}

__attribute__ ((visibility("default")))
void i_close(int id) {
	input_stream *i = in_list[id];
	close(i->fd);

	free(i);

	in_list[id] = 0;
}


__attribute__ ((visibility("default")))
int o_create(const char *f, uint64_t start) {
	int od = 0;

	od = stream_find_struct_storage((uintptr_t **)&out_list, &out_len);

	output_stream *o = xmalloc(sizeof(output_stream));
	out_list[od] = o;

	o->fd = open(f, O_RDWR | O_CREAT, S_IRUSR | S_IWUSR);
	if(o->fd < 0) {
		printf("Error in o_create: '%s'\n", strerror(errno));
		exit(1);
	}

	lseek(o->fd, start*sizeof(uint32_t), SEEK_SET);

	return od;
}

__attribute__ ((visibility("default")))
void o_write(int od, uint32_t v) {
	output_stream *o = out_list[od];
	int r = write(o->fd, &v, sizeof(uint32_t));

	if(r < 0) {
		errorAndDie(2);
	}
}

__attribute__ ((visibility("default")))
void o_close(int od) {
	output_stream *o = out_list[od];
	close(o->fd);
	free(o);

	out_list[od] = 0;
}
