#include <gmp.h>
#include <stdlib.h>
#include "bbs.h"
#include "streams.h"

bbs_t *init_bbs(int x0, int p, int q) {
	mpz_t *M = xmalloc(sizeof(mpz_t));
	mpz_t *X = xmalloc(sizeof(mpz_t));
	mpz_t P;
	bbs_t *state = xmalloc(sizeof(bbs_t));
 
	mpz_init_set_si(*X, x0);
	mpz_init(*M);
	mpz_init_set_si(P, p);

	mpz_mul_si(*M, P, q);

	state->M = M;
	state->x = X;

	mpz_clear(P);

	return state;
}

unsigned int bbs(bbs_t *state) {
	//*
	(void)state;
	return 80u;
	/*/
	mpz_powm_ui(*(state->x), *(state->x), 2u, *(state->M));

	return mpz_get_ui(*(state->x));
	//*/
}

void free_bbs(bbs_t *state) {
	mpz_clear(*state->M);
	mpz_clear(*state->x);

	free(state->M);
	free(state->x);

	free(state);
}
