#!/usr/bin/env bash
REPEAT_COUNT=3  # Times we repeat each test
TESTMAX=84    # Maximal number of tests
RESULTS_FOLDER=SORTING_RESULTS
TMP_FOLDER=tmp

DEBUG="1"

# TODO:
# - Check if buffer size is above write/read size?
# - Switch around repetitions, so they are outside.

REPETITION=0
TEST=0

## DEFAULTS START
declare -a Prange=(0);
declare -a mrange=(0);
## DEFAULTS END

PARAM_PRESENT=0;

HOST=`hostname | awk -F. '{print $1}'`;

# The test being performed
DOING_TEST="";

TESTNAME="";
EXE="";
CLEANUP="";

USAGE="${0} (mergesort | quicksort | heapsort)"

case ${1} in
	"ms" | "mergesort" )
		TESTNAME="External_MergeSort";
		EXE="./memlock/memlock ../IO1/mergesort -B 1048576 -d 16 -i INPUT -M 104857600"
		CLEANUP="rm -f sorted.out";;
	"qs" | "quicksort" )
		TESTNAME="QuickSort";
		EXE="./memlock/memlock quicksort/quicksort -B 1048576 -i INPUT"
		CLEANUP="rm -f sorted.out";;
	"hs" | "heapsort" )
		TESTNAME="HeapSort";
		EXE="./memlock/memlock heapsort/heapsort -B 1048576 -i INPUT"
		CLEANUP="rm -f sorted.out";;
	* )
		echo ${USAGE}
		exit;;
esac

# What we write to the damned file.
STAMP="BENCHMARK ${HOST}@`date -u` DOING: ${DOING_TEST}"

# Files we try to sort
declare -a Files=("TEST640" "TEST1280" "TEST1920" "TEST2560" "TEST3840" "TEST5120")

function reportProgress() {
        curl monitor.dat7.dk --data "{\"machine\": \"${HOST}\", \"iteration\": ${1},\
                \"iteration_max\": ${2}, \"description\": \"$3\"}" -X POST -H\
                "Content-Type: application/json" --silent -o /dev/null
}

trap "tput cvvis; echo \"\"; sleep 1; reportProgress 1 1 Interrupted; exit" 2 3 15

function clearCaches() {
	if [[ ${UID} -eq 0 ]]; then
		echo 3 > /proc/sys/vm/drop_caches
		blockdev --flushbufs /dev/sda
		sync
	else
		echo "NOT ROOOOOOOT!"
	fi
}

function clearTmp() {
	if [[ ${DEBUG} != "1" ]]; then
		eval ${CLEANUP};
	fi
}

function performTest() {
	local FILE=$1;

	# Clear the lines for output
	echo -en "\r"
	tput el

	printf "Performing iteration %d/%d of test %d/%d\n" ${REPETITION} \
		${REPEAT_COUNT} ${TEST} ${TESTMAX}

	reportProgress $(( (${TEST} - 1) * ${REPEAT_COUNT} + ${REPETITION} ))\
		$(( ${REPEAT_COUNT} * ${TESTMAX} )) "${TESTNAME}: ${FILE} ${REPETITION}/${REPEAT_COUNT}"

	# Where we save our data.
	OUTFILE="${RESULTS_FOLDER}/${TESTNAME}.${FILE}.csv"

	#if [ ! -f ${OUTFILE} ]; then
	#	echo ${STAMP} >> ${OUTFILE}
	#fi

	if [[ ${DEBUG} != "1" ]]; then
		${EXE/INPUT/${FILE}} >> ${OUTFILE};
	else
		echo "${EXE/INPUT/${FILE}}";
		sleep 0.9
	fi
}

function testWrapper() {
	local FILE=$1

	clearTmp
	performTest ${FILE}
	clearCaches
}

TESTMAX=$(( ${#Files[@]} ))

tput civis
mkdir -p ${RESULTS_FOLDER}

#for f in "${RESULTS_FOLDER}/*"
#do
#	echo ${STAMP} | tee -a ${f} >> /dev/null
#done

echo ""

TEST=0
for file in ${Files[@]}; do
	REPETITION=0
	TEST=$(( ${TEST} + 1));
	for r in `seq 1 ${REPEAT_COUNT}`; do
		REPETITION=$(( ${REPETITION} + 1 ));
		testWrapper ${file};
	done
done

tput cvvis
echo ""

reportProgress 1 1 Stopped
