#!/usr/bin/env bash

export LC_NUMERIC=en_US.UTF-8

LOGFILE="RUN_BATCH.LOG"
TIME=`date`
HOST=`hostname | awk -F. '{print $1}'`

function reportProgress() {
        curl monitor.dat7.dk --data "{\"machine\": \"${HOST}\", \"iteration\": 1,\
                \"iteration_max\": 1, \"description\": \"$1\"}" -X POST -H\
                "Content-Type: application/json" --silent -o /dev/null
}

trap "reportProgress Stopped; exit" INT QUIT

reportProgress "IO2 Test"

./heap

reportProgress "Idle"
