// Origin: https://gist.github.com/martinkunev/1365481/

// WARNING: Requires C99 compatible compiler

#ifndef H_INTERNAL_HEAP
#define H_INTERNAL_HEAP

#include <stdint.h>

typedef uint32_t type;
typedef int (*internal_heap_compare_t)(type a, type b);

typedef struct internal_heap {
	uint64_t size;          // Size of the allocated memory (in number of items)
	unsigned int count;     // Count of the elements in the heap
	type *data;             // Array with the elements
	internal_heap_compare_t cmp; // Compare function
} internal_heap_t;

void internal_heap_init(internal_heap_t *restrict h, uint64_t data_size,
		internal_heap_compare_t cmp);
void internal_heap_push(internal_heap_t *restrict h, type value);
void internal_heap_pop(internal_heap_t *restrict h);

// Returns the biggest element in the heap
#define internal_heap_front(h) (*(h)->data)

// Frees the allocated memory
#define internal_heap_term(h) (free((h)->data))

void internal_heapify(type data[restrict], unsigned int count);

#endif
