// Origin: https://gist.github.com/martinkunev/1365481/
// WARNING: Requires C99 compatible compiler

#ifndef H_DMERGE_HEAP
#define H_DMERGE_HEAP

#include <stdint.h>

typedef uintptr_t dtype;
typedef int (*dmerge_internal_heap_compare_t)(dtype a, dtype b);

typedef struct dmerge_internal_heap {
	uint64_t size; 				// Size of the allocated memory (in number of items)
	unsigned int count; 		// Count of the elements in the heap
	dtype *data; 				// Array with the elements
	dmerge_internal_heap_compare_t cmp; // Compare function
} dmerge_internal_heap_t;

void dmerge_internal_heap_init(dmerge_internal_heap_t *restrict h, 
		dmerge_internal_heap_compare_t cmp);
void dmerge_internal_heap_push(dmerge_internal_heap_t *restrict h, dtype value);
void dmerge_internal_heap_pop(dmerge_internal_heap_t *restrict h);

// Returns the biggest element in the heap
#define dmerge_internal_heap_front(h) (*(h)->data)

// Frees the allocated memory
#define dmerge_internal_heap_term(h) (free((h)->data))

void dmerge_internal_heapify(dtype data[restrict], unsigned int count);
#endif
