#include <stdlib.h>
#include <stdio.h>
#include <streams.h>
#include <stdint.h>
#include <inttypes.h>
#include "heap.h"
#include "dmerge.h"
#include "dmerge_internal_heap.h"

int dmerge_min_heap_comparer(uintptr_t a, uintptr_t b) {
	el_t *elA = (el_t *)a;
	el_t *elB = (el_t *)b;

	return elA->el < elB->el;
}

uint32_t *dmerge(int d, in_stream *in, int *ifds, out_stream *out, int ofd, 
		int buf_length, int length, int offset) {
	int i;
	uint32_t *removed;
	dmerge_internal_heap_t h;
	el_t *el;

	// Allocating space for count of removed elements from different stream
	removed = xmalloc(sizeof(uint32_t)*d);

	// Init heap
	dmerge_internal_heap_init(&h, dmerge_min_heap_comparer);

	// Fetch the first elements into the heap
	for (i = 0; i < d; i++) {
		if (!in->eos(ifds[i])) {
			//TODO: Allocate s_buffer at startup instead of allocating this 
			//every time
			el = xmalloc(sizeof(el_t));
			el->el = in->last(ifds[i]);
			el->fd = i;
			removed[i] = 0;

			dmerge_internal_heap_push(&h, (uintptr_t)el);
		}
	}

	// Merge
	for (i = 0; i < length; ) {
		el = (el_t *)dmerge_internal_heap_front(&h);

		dmerge_internal_heap_pop(&h);

		removed[el->fd] += 1;
		out->prepend(ofd, el->el);
		i++;

		if (!in->eos(ifds[el->fd])) {
			el->el = in->last(ifds[el->fd]);

			dmerge_internal_heap_push(&h, (uintptr_t)el);
		} else {
			free(el);
		}
	}

	while (h.count > 0) {
		el = (el_t *)dmerge_internal_heap_front(&h);
		dmerge_internal_heap_pop(&h);
		free(el);
	}

	// Terminate heap
	dmerge_internal_heap_term(&h);

	return removed;
}
