class Company < ActiveRecord::Base
  validates :cvr,
    numericality: {only_integer: true, message: "Must be an integer"},
    length: {is: 8, message: "Must be 8 digits"},
    presence: {is: true, message: "Must be set"},
    uniqueness: {is: true, message: "Company with CVR %{value} already exists"}

  validates :name, :address, :city, :country,
    presence: {is: true, message: "Must be set"}

  auto_strip_attributes :name, :address, :city, :country
end
