CompanyIndex::Api.controllers :companies do
  
  # get :index, :map => '/foo/bar' do
  #   session[:foo] = 'bar'
  #   render 'index'
  # end

  # get :sample, :map => '/sample/url', :provides => [:any, :js] do
  #   case content_type
  #     when :js then ...
  #     else ...
  # end

  # get :foo, :with => :id do
  #   "Maps to url '/foo/#{params[:id]}'"
  # end

  # get '/example' do
  #   'Hello world!'
  # end
 
  # Database connections apparently don't close.
  after do
    ActiveRecord::Base.connection.close
  end
  
  get :index do
    content_type(:json)
    Company.all.select('id, name, cvr').to_json
  end
  
  get :index, :with => :id do
    content_type(:json)
    company = Company.find_by(id: params[:id]).to_json
    if company == "null"
      status 404
    else
      company
    end
  end

  delete :index, :with => :id do
    company = Company.find_by(:id => params[:id])
    unless company.nil?
      company.destroy
    else
      status 404
    end
  end

  post :index do
    content_type :json
    begin
      json_in = JSON.parse(env['rack.input'].gets).symbolize_keys

      @company = Company.new(json_in)

      if @company.valid?
        #@company.each do |key, value|
        #  value.strip!
        #end
        @company.save
        @company.to_json
      else
        status 400
        @company.errors.messages.to_json
      end
    rescue Exception => e
      puts(e)
      status 400
      "{'response': 'invalid JSON'}"
    end
  end
end
